/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;
import net.montoyo.wd.block.BlockKeyboardLeft;
import net.montoyo.wd.block.BlockPeripheral;
import net.montoyo.wd.core.IPeripheral;
import net.montoyo.wd.entity.TileEntityKeyboard;
import net.montoyo.wd.item.ItemLinker;
import net.montoyo.wd.net.WDNetworkRegistry;
import net.montoyo.wd.net.client_bound.S2CMessageCloseGui;
import net.montoyo.wd.utilities.BlockSide;
import net.montoyo.wd.utilities.Vector3i;
import org.jetbrains.annotations.NotNull;

public class BlockKeyboardRight
extends Block
implements IPeripheral {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public BlockKeyboardRight() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(1.5f, 10.0f));
    }

    private static void removeLeftPiece(BlockState state, Level world, BlockPos pos) {
        BlockPos relative = pos.m_121945_(BlockKeyboardLeft.mapDirection(((Direction)state.m_61143_((Property)FACING)).m_122424_()));
        BlockState ns = world.m_8055_(relative);
        if (ns.m_60734_() instanceof BlockKeyboardLeft) {
            world.m_7731_(relative, Blocks.f_50016_.m_49966_(), 3);
        }
    }

    public static void remove(BlockState state, Level world, BlockPos pos, boolean setState, boolean drop) {
        BlockKeyboardRight.removeLeftPiece(state, world, pos);
        if (setState) {
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        }
        WDNetworkRegistry.INSTANCE.send(PacketDistributor.NEAR.with(() -> BlockPeripheral.point(world, pos)), (Object)new S2CMessageCloseGui(pos));
    }

    public void m_6810_(BlockState arg, Level arg2, BlockPos arg3, BlockState arg4, boolean bl) {
        if (!arg2.f_46443_) {
            BlockKeyboardRight.remove(arg, arg2, arg3, false, false);
        }
        super.m_6810_(arg, arg2, arg3, arg4, bl);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public boolean m_180643_(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return BlockKeyboardLeft.KEYBOARD_AABBS[((Direction)state.m_61143_((Property)FACING)).ordinal() - 2];
    }

    @Override
    public boolean connect(Level world, BlockPos pos, BlockState state, Vector3i scrPos, BlockSide scrSide) {
        TileEntityKeyboard keyboard = BlockKeyboardLeft.getTileEntity(state, world, pos);
        return keyboard != null && keyboard.connect(world, pos, state, scrPos, scrSide);
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        TileEntityKeyboard tek;
        double rpos = (entity.m_20186_() - (double)pos.m_123342_()) * 16.0;
        if (!world.f_46443_ && rpos >= 1.0 && rpos <= 2.0 && Math.random() < 0.25 && (tek = BlockKeyboardLeft.getTileEntity(state, world, pos)) != null) {
            tek.simulateCat(entity);
        }
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player.m_21120_(hand).m_41720_() instanceof ItemLinker) {
            return InteractionResult.PASS;
        }
        TileEntityKeyboard tek = BlockKeyboardLeft.getTileEntity(state, level, pos);
        if (tek != null) {
            return tek.onRightClick(player, hand);
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_7952_(BlockState arg, BlockGetter arg2, BlockPos arg3) {
        return Shapes.m_83040_();
    }
}

